package com.agilex.healthcare.veteranappointment.utils.linkbuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.atom.rel;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequest;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequests;
import com.agilex.healthcare.veteranappointment.domain.VARLinkTitles;
import gov.va.vamf.security.v1.VamfUser;

import javax.ws.rs.core.UriBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;

public class AppointmentRequestLinkBuilder extends PatientDataLinkBuilder<VARAppointmentRequests, VARAppointmentRequest> {

	public AppointmentRequestLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI getCannonicalSelfUri(VARAppointmentRequest dataItem) {
		String encodedUserId = getEncodedUserId(dataItem);
		String encodedAppointmentRequestId = encode(dataItem.getAppointmentRequestId());
		
		URI selfUri = UriBuilder.fromPath(getPath()).path("appointment-service").path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority())
				.path(encodedUserId).path("appointments").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedAppointmentRequestId).build();
		
		return selfUri;
	}

    private String getEncodedUserId(VARAppointmentRequest dataItem) {
		return encode(dataItem.getPatientIdentifier().getUniqueId());
    }

    @Override
	protected void fillCustomRelatedLinks(VARAppointmentRequest dataItem) {
		AtomLink link = new AtomLink();
		link.setRel(rel.related);
        String encodedUserId = getEncodedUserId(dataItem);
        String encodedAppointmentRequestId = encode(dataItem.getAppointmentRequestId());
        URI relatedUri = UriBuilder.fromPath(getPath()).path("appointment-service").path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority())
                .path(encodedUserId).path("appointment-requests").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedAppointmentRequestId).path("messages").build();

		link.setHref(relatedUri);
		link.setTitle(VARLinkTitles.AppointmentRequestMessages);
		dataItem.getLink().add(link);

        link = new AtomLink();
        link.setRel(rel.related);
        URI newMessageFlagUri = UriBuilder.fromPath(getPath()).path("appointment-service").path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority())
                .path(encodedUserId).path("appointment-requests").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedAppointmentRequestId).path("messages").path("read").build();
        link.setHref(newMessageFlagUri);
        link.setTitle(VARLinkTitles.AppointmentRequestNewMessageFlag);
        dataItem.getLink().add(link);

        link = new AtomLink();
        link.setRel(rel.related);
        URI newProviderSeenFlagUri = UriBuilder.fromPath(getPath()).path("appointment-service").path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority())
                .path(encodedUserId).path("appointment-requests").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedAppointmentRequestId).path("appointment").path("provider-read").build();
        link.setHref(newProviderSeenFlagUri);
        link.setTitle(VARLinkTitles.AppointmentRequestProviderSeenFlag);
        dataItem.getLink().add(link);
    }
	
	@Override
	protected void fillCustomRelatedLinks(VARAppointmentRequests dataList) {
	}
	
	private String encode(String id) {
		String encoded;
		try {
			encoded = URLEncoder.encode(id, "UTF-8");
		} catch (UnsupportedEncodingException failedToEncode) {
			throw new RuntimeException("Could not encode a URL parameter for AppointmentRequests");
		}
		return encoded;
	}

	@Override
	public URI getCannonicalUriForCollection(URI patientUri) {
		return null;
	}

}